#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//KinestesiaMod01.fsh by   felipunkerito
//https://www.shadertoy.com/view/.....
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177 //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define FAR 10.0
#define STEPS 256
#define EPS 0.0001
const float PI = 3.14159265359;

// This is based upon two tutorials: https://www.youtube.com/watch?v=CHmneY8ry84&t=211s by iq
// and 							   : https://www.youtube.com/watch?v=RGmgHfbU0hU by vgs

float hash( float n )
{

    return fract( sin( n ) * 45843.349 );
    
}

float noise( in vec3 x )
{

    vec3 p = floor( x );
    vec3 k = fract( x );
    
    k *= k * k * ( 3.0 - 2.0 * k );
    
    float n = p.x + p.y * 57.0 + p.z * 113.0; 
    
    float a = hash( n );
    float b = hash( n + 1.0 );
    float c = hash( n + 57.0 );
    float d = hash( n + 58.0 );
    
    float e = hash( n + 113.0 );
    float f = hash( n + 114.0 );
    float g = hash( n + 170.0 );
    float h = hash( n + 171.0 );
    
    float res = mix( mix( mix ( a, b, k.x ), mix( c, d, k.x ), k.y ),
                     mix( mix ( e, f, k.x ), mix( g, h, k.x ), k.y ),
                     k.z
    				 );
    
    return res;
    
}

float fbm( in vec3 p )
{

    float f = 0.0;
    f += 0.5000 * noise( p ); p *= 2.02;
    f += 0.2500 * noise( p ); p *= 2.03;
    f += 0.1250 * noise( p ); p *= 2.01;
    f += 0.0625 * noise( p );
    f += 0.0125 * noise( p );
    return f / 0.9375;
    
}

vec3 flowerMaterial( in vec3 pos, in vec3 nor )
{
    
    float a = atan( pos.x, pos.z );
    float r = length( pos.xz );
    
    // Blue colour
    vec3 col = vec3( 0.0, 0.0, 1.0 );
    
    // Mix to red
    float f = fbm( pos );
    col = mix( col, vec3( 1.0, 0.0, 0.0 ), f );
    
    return col;

}

float map( vec3 p )
{

    float wave = texture2D( iChannel0, vec2( 0.0, 0.85 ) ).x;
    // Change this to a lower number if there is too much distortion
    wave *= 0.08; //0.12
    
    float r = 1.0 + 0.15 * cos( 5.0 * atan( p.x, p.y ) ) + 0.4 * p.z;
    
    float t = fbm( p + wave + ( iTime * 0.5 ) - r );;
    
    float plane = p.y + 1.8;
    
    float sphere = length( p ) - ( 2.0 * t );
    
    if( plane < sphere ) sphere = plane;
    
    return sphere;
    
}

vec3 grad( vec3 p )
{
    
    vec2 e = vec2( 0.0, EPS );
    vec3 n = vec3( map( p + e.yxx ) - map( p - e.yxx ),
                   map( p + e.xyx ) - map( p - e.xyx ),
                   map( p + e.xxy ) - map( p - e.xxy )
     				);
    return n;

}

float softShadows( in vec3 ro, in vec3 rd )
{

    float res = 1.0;
    for( float t = 0.1; t < 8.0; ++t )
    {
        
        float h = map( ro + rd * t );
        
        if( h < 0.001 ) return 0.0;
        res = min( res, 4.0 * h / t );
        t += h;
    
    }
    
    return res;
    
}

vec3 randomSphereDir(vec2 rnd)
{
	float s = rnd.x*PI*2.;
	float t = rnd.y*2.-1.;
	return vec3(sin(s), cos(s), t) / sqrt(1.0 + t * t);
}

vec3 randomHemisphereDir(vec3 dir, float i)
{
	vec3 v = randomSphereDir( vec2(hash(i+1.), hash(i+2.)) );
	return v * sign(dot(v, dir));
}

float ambientOcclusion( in vec3 p, in vec3 n, in float maxDist, in float falloff )
{
	const int nbIte = 32;
    const float nbIteInv = 1./float(nbIte);
    const float rad = 1.-1.*nbIteInv; //Hemispherical factor (self occlusion correction)
    
	float ao = 0.0;
    
    for( int i=0; i<nbIte; i++ )
    {
        float l = hash(float(i))*maxDist;
        vec3 rd = normalize(n+randomHemisphereDir(n, l )*rad)*l; // mix direction with the normal
        													    // for self occlusion problems!
        
        ao += (l - max(map( p + rd ),0.)) / maxDist * falloff;
    }
	
    return clamp( 1.-ao*nbIteInv, 0., 1.);
}

vec3 shade( vec3 ro, vec3 rd, float t )
{

	vec3 pos = ro + rd * t;
    vec3 n = normalize( grad( pos ) );
    
    vec3 lig = normalize( vec3( 1.0, 0.8, 0.6 ) );
    vec3 blig = vec3( -lig.x, -lig.y, -lig.z );
    vec3 ref = reflect( rd, n );
    
    // AO from XT95 at: https://www.shadertoy.com/view/4sdGWN 
    
    float a = ambientOcclusion( pos, n, 4.0, 2.0 );
    float dif = max( 0.0, dot( n, lig ) );
    float con = 1.0;
    float sha = softShadows( pos, lig );
    float spe = pow( clamp( dot( lig, ref ), 0.0, 1.0 ), 16.0 );
    float amb = 0.5 + 0.5 * n.y;
    float bac = max( 0.0, 0.2 + 0.8 * dot( n, blig ) );
    float rim = pow( 1.0 + dot(n, rd), 2.0 );
    
    vec3 col = con * vec3( 0.1, 0.15, 0.2 );
    col += amb * vec3( 0.1, 0.15, 0.2 );
    col += dif * vec3( 1.0, 0.97, 0.85 ) * sha;
    col += bac * vec3( 1.0, 0.97, 0.85 ) * bac;
    
    col = sqrt( col );
    col *= 0.6;
    
    if( pos.y > -1.79 )
    {
    
    	col *= flowerMaterial( pos, n );
        
    }
    
    else
    
    {
    
        vec3 x = texture2D( iChannel1, pos.xz, 1.0 ).xyz;
        col *= x;
    }
    
    col += 0.1 * rim;
    col += 1.0 * spe;
    col *= a;
    
    return col;
 
}

// Camera taken from symbol of chaos by lsdlive https://www.shadertoy.com/view/4stczB

vec3 camera(vec3 ro, vec2 uv, vec3 ta) {
	vec3 fwd = normalize(ta - ro);
	vec3 left = cross(vec3(0, 1, 0), fwd);
	vec3 up = cross(fwd, left);
	return normalize(fwd + uv.x*left + up*uv.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = ( -iResolution.xy + 2.0 * fragCoord ) / iResolution.xy;
    uv.x *= iResolution.x / iResolution.y;
    
    vec4 mouse = iMouse / iResolution.xyxy;
    
    float dt = iTime * .3;
	vec3 ro = vec3( 2.5 * cos(dt), 1.0, -2.5 * sin(dt));
    vec3 ta = vec3(0, 0, 0);
	vec3 rd;

	rd = camera(ro, uv, ta);

    float t = 0.0; float d = EPS;
    for( int i = 0; i < STEPS; ++i )
    {
    
        d = 0.5 * map( ro + rd * t );
        
        if( d < EPS || t > FAR ) break;
        
        t += d;
        
    }
    
    // Time varying pixel color
    vec3 col;
    
    if( d < EPS )
    {
    
        col = shade( ro, rd, t );
        
    }
    else
    {
        col = mix( vec3( 0.1, 0.10, 0.2 ), vec3( 0.3, 0.2, 0.1 ), uv.y );
    
    }

    // Output to screen
    fragColor = vec4( col, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

